/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.models.entities;

import com.alexander.mutantmore.config.MutantBlazeClientConfig;
import com.alexander.mutantmore.entities.MutantBlaze;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedTickingGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class MutantBlazeModel
extends AnimatedTickingGeoModel<MutantBlaze> {
    public ResourceLocation getAnimationResource(MutantBlaze entity) {
        return new ResourceLocation("mutantmore", "animations/mutant_blaze.animation.json");
    }

    public ResourceLocation getModelResource(MutantBlaze entity) {
        return new ResourceLocation("mutantmore", "geo/mutant_blaze.geo.json");
    }

    public ResourceLocation getTextureResource(MutantBlaze entity) {
        return (Boolean)MutantBlazeClientConfig.armoured_texture.get() != false ? new ResourceLocation("mutantmore", "textures/entities/mutant_blaze_armoured.png") : new ResourceLocation("mutantmore", "textures/entities/mutant_blaze.png");
    }

    public void setLivingAnimations(MutantBlaze entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone shield7 = this.getAnimationProcessor().getBone("shield7");
        IBone shield6 = this.getAnimationProcessor().getBone("shield6");
        IBone shield5 = this.getAnimationProcessor().getBone("shield5");
        IBone shield4 = this.getAnimationProcessor().getBone("shield4");
        IBone shield3 = this.getAnimationProcessor().getBone("shield3");
        IBone shield2 = this.getAnimationProcessor().getBone("shield2");
        IBone shield1 = this.getAnimationProcessor().getBone("shield");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (entity.isShieldBroken(0)) {
            shield7.setHidden(true);
        } else {
            shield7.setHidden(false);
        }
        if (entity.isShieldBroken(1)) {
            shield4.setHidden(true);
        } else {
            shield4.setHidden(false);
        }
        if (entity.isShieldBroken(2)) {
            shield5.setHidden(true);
        } else {
            shield5.setHidden(false);
        }
        if (entity.isShieldBroken(3)) {
            shield6.setHidden(true);
        } else {
            shield6.setHidden(false);
        }
        if (entity.isShieldBroken(4)) {
            shield3.setHidden(true);
        } else {
            shield3.setHidden(false);
        }
        if (entity.isShieldBroken(5)) {
            shield1.setHidden(true);
        } else {
            shield1.setHidden(false);
        }
        if (entity.isShieldBroken(6)) {
            shield2.setHidden(true);
        } else {
            shield2.setHidden(false);
        }
        if (Minecraft.m_91087_().m_91104_()) {
            if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
                head.setRotationX(head.getRotationX());
                head.setRotationY(head.getRotationY());
            }
        } else if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * (float)Math.PI / 180.0f);
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * (float)Math.PI / 180.0f);
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        LivingEntity livingEntity = (LivingEntity)animatable;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (livingEntity instanceof MutantBlaze && ((MutantBlaze)livingEntity).isFlying()) {
            parser.setValue("query.move_speed", 0.0);
        } else {
            parser.setValue("query.move_speed", (double)(groundSpeed * 15.0f));
        }
    }
}

